' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.Data.SqlClient
Imports System.Collections.Generic

''' <summary>
''' Ta klasa odpowiada za cay dostp do danych w sklepie internetowym.
''' </summary>
Public Class ShopManagerDB

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy ShopManagerDB.
  ''' </summary>
  Private Sub New()
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Zapisuje zamwienie oraz zwizane z nim szczegy w bazie danych.
  ''' </summary>
  ''' <param name="theShoppingCart">Koszyk, ktry jest zapisywany jako zamwienie wraz z powizanymi szczegami zamwienia.</param>
  ''' <param name="theCustomer">Klient skadajcy zamwienie.</param>
  Public Shared Function FinalizeOrder(ByVal theShoppingCart As ShoppingCart, ByVal theCustomer As Customer) As Integer
    Dim myTransaction As SqlClient.SqlTransaction = Nothing

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        myConnection.Open()

        myTransaction = myConnection.BeginTransaction

        Dim myCommand As SqlCommand = New SqlCommand( _
              "sprocOrderBaseInsertSingleItem", myConnection)
        myCommand.Transaction = myTransaction
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@CustomerId", theCustomer.CustomerId)
        myCommand.Parameters.AddWithValue("@FirstName", theCustomer.FirstName)
        myCommand.Parameters.AddWithValue("@LastName", theCustomer.LastName)
        myCommand.Parameters.AddWithValue("@Street", theCustomer.Street)
        myCommand.Parameters.AddWithValue("@ZipCode", theCustomer.ZipCode)
        myCommand.Parameters.AddWithValue("@City", theCustomer.City)
        myCommand.Parameters.AddWithValue("@Country", theCustomer.Country)

        Dim theReturnValue As SqlParameter = New SqlParameter()
        theReturnValue.Direction = ParameterDirection.ReturnValue
        myCommand.Parameters.Add(theReturnValue)

        myCommand.ExecuteNonQuery()

        Dim orderId As Integer = Convert.ToInt32(theReturnValue.Value)

        ' Kiedy ju zapisalimy zamwienie, zapiszmy take szczegy zamwienia
        Dim myCommand2 As SqlCommand = New SqlCommand("sprocOrderDetailInsertSingleItem", myConnection)
        myCommand2.Transaction = myTransaction
        myCommand2.CommandType = CommandType.StoredProcedure

        Dim orderBaseIdParam As SqlParameter = _
            New SqlParameter("OrderBaseId", SqlDbType.Int)
        myCommand2.Parameters.Add(orderBaseIdParam)

        Dim productIdParam As SqlParameter = _
            New SqlParameter("productId", SqlDbType.Int)
        myCommand2.Parameters.Add(productIdParam)

        Dim priceParam As SqlParameter = _
            New SqlParameter("price", SqlDbType.Money)
        myCommand2.Parameters.Add(priceParam)

        Dim quantityParam As SqlParameter = _
            New SqlParameter("quantity", SqlDbType.Int)
        myCommand2.Parameters.Add(quantityParam)

        For Each myOrderedProduct As OrderedProduct In theShoppingCart.Items
          orderBaseIdParam.Value = orderId
          productIdParam.Value = myOrderedProduct.ProductId
          priceParam.Value = myOrderedProduct.Price
          quantityParam.Value = myOrderedProduct.Quantity
          myCommand2.ExecuteNonQuery()
        Next
        myTransaction.Commit()
        Return orderId
      End Using
    Catch ex As Exception
      myTransaction.Rollback()
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Zwraca list z dostpnymi kategoriami produktw.
  ''' </summary>
  ''' <returns>DataSet zawierajcy dwie kolumny: Id i Description dla kadej z kategorii.</returns>
  Public Shared Function GetProductCategories() As DataSet
    Dim dataSet As DataSet = New DataSet

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocCategorySelectList", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(dataSet)
        myConnection.Close()
        Return dataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function


  ''' <summary>
  ''' Zwraca list produktw w okrelonej kategorii.
  ''' </summary>
  ''' <param name="categoryId">Identyfikator kategorii w bazie danych.</param>
  ''' <returns>Lista produktw w danej kategorii.</returns>
  Public Shared Function GetProducts(ByVal categoryId As Integer) As List(Of Product)
    Dim productList As List(Of Product) = New List(Of Product)

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand("sprocProductSelectListByProductCategory", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure
        myCommand.Parameters.AddWithValue("@categoryId", categoryId)

        Dim theProduct As Product 'Tymczasowy produkt do dodania do naszej listy produktw

        myConnection.Open()
        Using myReader As SqlDataReader = _
              myCommand.ExecuteReader(CommandBehavior.CloseConnection)
          While myReader.Read()
            theProduct = New Product( _
                myReader.GetInt32(myReader.GetOrdinal("Id")), _
                categoryId)
            theProduct.Title = myReader.GetString(myReader.GetOrdinal("Title"))
            theProduct.Description = myReader.GetString(myReader.GetOrdinal("Description"))
            theProduct.Price = myReader.GetDecimal(myReader.GetOrdinal("Price"))
            theProduct.PictureUrlSmall = myReader.GetString(myReader.GetOrdinal("PictureUrlSmall"))
            theProduct.PictureUrlMedium = myReader.GetString(myReader.GetOrdinal("PictureUrlMedium"))
            theProduct.PictureUrlLarge = myReader.GetString(myReader.GetOrdinal("PictureUrlLarge"))
            productList.Add(theProduct)
          End While
          myReader.Close()
        End Using
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
    Return productList
  End Function


  ''' <summary>
  ''' Wstawia nowy produkt do bazy danych.
  ''' </summary>
  Public Shared Sub InsertProduct(ByVal theProduct As Product)
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand("sprocProductInsertUpdateSingleItem", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        If theProduct.Id = -1 Then
          myCommand.Parameters.AddWithValue("@id", DBNull.Value)
        Else
          myCommand.Parameters.AddWithValue("@id", theProduct.Id)
        End If
        myCommand.Parameters.AddWithValue("@title", theProduct.Title)
        myCommand.Parameters.AddWithValue("@description", theProduct.Description)
        myCommand.Parameters.AddWithValue("@price", theProduct.Price)
        myCommand.Parameters.AddWithValue("@categoryId", theProduct.CategoryId)
        myCommand.Parameters.AddWithValue("@pictureUrlSmall", theProduct.PictureUrlSmall)
        myCommand.Parameters.AddWithValue("@pictureUrlMedium", theProduct.PictureUrlMedium)
        myCommand.Parameters.AddWithValue("@pictureUrlLarge", theProduct.PictureUrlLarge)

        myConnection.Open()

        myCommand.ExecuteNonQuery()
        myConnection.Close()
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Sub

  ''' <summary>
  ''' "Usuwa" pozycj z bazy danych oznaczajc j jako skasowan.
  ''' </summary>
  Public Shared Sub DeleteProduct(ByVal theProduct As Product)
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand("sprocProductDeleteSingleItem", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@id", theProduct.Id)

        myConnection.Open()

        myCommand.ExecuteNonQuery()
        myConnection.Close()
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Sub

  ''' <summary>
  ''' Zwraca pojedynczy egzemplarz produktu.
  ''' </summary>
  ''' <returns>dany product, lub Nothing jeli nie mona byo znale pozycji.</returns>
  Public Shared Function GetProduct(ByVal productId As Integer) As Product
    Dim theProduct As Product = Nothing 'Tymczasowy produkt do dodania do naszej listy produktw

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand("sprocProductSelectSingleItem", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@productId", productId)

        myConnection.Open()
        Using myReader As SqlDataReader = myCommand.ExecuteReader(CommandBehavior.CloseConnection)
          If myReader.Read() Then
            Dim test As Integer = myReader.GetInt32(myReader.GetOrdinal("CategoryId"))
            theProduct = New Product(myReader.GetInt32(myReader.GetOrdinal("Id")), myReader.GetInt32(myReader.GetOrdinal("CategoryId")))
            theProduct.Title = myReader.GetString(myReader.GetOrdinal("Title"))
            theProduct.Description = myReader.GetString(myReader.GetOrdinal("Description"))
            theProduct.Price = myReader.GetDecimal(myReader.GetOrdinal("Price"))
            theProduct.PictureUrlSmall = myReader.GetString(myReader.GetOrdinal("PictureUrlSmall"))
            theProduct.PictureUrlMedium = myReader.GetString(myReader.GetOrdinal("PictureUrlMedium"))
            theProduct.PictureUrlLarge = myReader.GetString(myReader.GetOrdinal("PictureUrlLarge"))
          End If
          myReader.Close()
        End Using
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
    Return theProduct
  End Function

#End Region

End Class
